package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VdatosReqOsDao;
import com.ejie.ab04b.model.VdatosReqOs;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdatosReqOsServiceImpl generated by UDA, 20-jun-2017 10:04:30.
 * 
 * @author UDA
 */

@Service(value = "vdatosReqOsService")
public class VdatosReqOsServiceImpl implements VdatosReqOsService {

	@Autowired
	private VdatosReqOsDao vdatosReqOsDao;

	/**
	 * Inserts a single row in the VdatosReqOs table.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosReqOs the vdatos req os
	 * @return the vdatos req os
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdatosReqOs add(VdatosReqOs vdatosReqOs) {
		return this.vdatosReqOsDao.add(vdatosReqOs);
	}

	/**
	 * Updates a single row in the VdatosReqOs table.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosReqOs the vdatos req os
	 * @return the vdatos req os
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VdatosReqOs update(VdatosReqOs vdatosReqOs) {
		return this.vdatosReqOsDao.update(vdatosReqOs);
	}

	/**
	 * Finds a single row in the VdatosReqOs table.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *  VdatosReqOs
	 *
	 * @param vdatosReqOs the vdatos req os
	 * @return the vdatos req os
	 */
	public VdatosReqOs find(VdatosReqOs vdatosReqOs) {
		return (VdatosReqOs) this.vdatosReqOsDao.find(vdatosReqOs);
	}

	/**
	 * Deletes a single row in the VdatosReqOs table.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *
	 * @param vdatosReqOs the vdatos req os
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VdatosReqOs vdatosReqOs) {
		this.vdatosReqOsDao.remove(vdatosReqOs);
	}

	/**
	 * Finds a list of rows in the VdatosReqOs table.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdatosReqOs>
	 *
	 * @param vdatosReqOs the vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VdatosReqOs> findAll(VdatosReqOs vdatosReqOs,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VdatosReqOs>) this.vdatosReqOsDao.findAll(vdatosReqOs,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VdatosReqOs table using like.
	 * 
	 *  vdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdatosReqOs>
	 *
	 * @param vdatosReqOs the vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VdatosReqOs> findAllLike(VdatosReqOs vdatosReqOs,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VdatosReqOs>) this.vdatosReqOsDao.findAllLike(vdatosReqOs,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VdatosReqOs table.
	 * 
	 *  filterVdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVdatosReqOs the filter vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VdatosReqOs filterVdatosReqOs,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vdatosReqOsDao.removeMultiple(filterVdatosReqOs, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VdatosReqOs table.
	 * 
	 *  filterVdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VdatosReqOs>
	 *
	 * @param filterVdatosReqOs the filter vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VdatosReqOs> filter(VdatosReqOs filterVdatosReqOs,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VdatosReqOs> listaVdatosReqOs = this.vdatosReqOsDao.findAllLike(
				filterVdatosReqOs, jqGridRequestDto, false);
		Long recordNum = this.vdatosReqOsDao.findAllLikeCount(
				filterVdatosReqOs != null ? filterVdatosReqOs
						: new VdatosReqOs(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VdatosReqOs>> reorderSelection = this.vdatosReqOsDao
					.reorderSelection(filterVdatosReqOs, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VdatosReqOs>(jqGridRequestDto,
					recordNum, listaVdatosReqOs, reorderSelection);
		}
		return new JQGridResponseDto<VdatosReqOs>(jqGridRequestDto, recordNum,
				listaVdatosReqOs);
	}

	/**
	 * Searches rows in the VdatosReqOs table.
	 * 
	 *  filterVdatosReqOs
	 *            VdatosReqOs
	 *  searchVdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VdatosReqOs>>
	 *
	 * @param filterVdatosReqOs the filter vdatos req os
	 * @param searchVdatosReqOs the search vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VdatosReqOs>> search(VdatosReqOs filterVdatosReqOs,
			VdatosReqOs searchVdatosReqOs, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.vdatosReqOsDao.search(filterVdatosReqOs, searchVdatosReqOs,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VdatosReqOs table.
	 * 
	 *  filterVdatosReqOs
	 *            VdatosReqOs
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVdatosReqOs the filter vdatos req os
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VdatosReqOs filterVdatosReqOs,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vdatosReqOsDao.reorderSelection(filterVdatosReqOs,
				jqGridRequestDto, startsWith);
	}

}
